#include "bbm.h"						/* resource file definitions */
#include <obdefs.h>
#include <osbind.h>
#include <gemdefs.h>
#include <aesbind.h>
#include <vdibind.h>
#include <stdio.h>
#include <stat.h>
#include <errno.h>

#define ARROW_MOUSE	graf_mouse(ARROW, &dummy)	/* change mouse to arrow */
#define BEE_MOUSE	graf_mouse(BUSY_BEE, &dummy)	/* change mouse to bee */
#define HIDE_MOUSE	graf_mouse(M_OFF, &dummy)	/* make mouse invisible */
#define SHOW_MOUSE	graf_mouse(M_ON, &dummy)		/* make mouse visible */
#define DESKSIZE	xdesk,ydesk,wdesk,hdesk

#define F1_KEY		0x3B00
#define F10_KEY	0x4400

#define NO		0
#define YES		1

#define BIT8CRY	0
#define BIT16CRY	1
#define BIT8RGB	2
#define BIT16RGB	3

int contrl[12], ptsin[256], ptsout[256], intin[256], intout[256];
int work_in[256], work_out[256];

int quit;						/* program ends when quit = 0 */
int button;					/* file selector button */
int dummy;					/* used in mouse change statements */
int handle;					/* vdi handle */
int xdesk,ydesk,wdesk,hdesk;		/* coordinates of usable part of screen */
int xdial,ydial,wdial,hdial;		/* coordinates of dialog box */
int pxdial,pydial;
int pwdial,phdial;				/* coordinates of percent dialog box */
long menuaddr;					/* address of menus */
int event_type;				/* evnt_multi event */
int mousex,mousey;				/* mouse position when event occurs */
int key;						/* key pressed when event occurs */
int mgbuf[8];					/* message buffer for evnt_multi */

char dirpath[120];				/* pathname with filename appended */
char pathname[120];				/* the complete path with filename */
char dirset[120];				/* used in the pathname construction */
int drive;					/* used in the pathname construction */
char drv[2];					/* used in the pathname construction */
char savepath[120];				/* new pathname with filename appended */
char savepathname[120];			/* pathname for new file */
int i;						/* temporary counter variable */
char name[13];					/* filename in file selector */
char ts[200];					/* temp string used for printing stuff in file */

char picname[13];				/* name of image to be printed in file */
long filesize[99];				/* length of entire files (99 max) */
char filename[99][13];			/* filenames (99 max) */
int filecount;					/* number of files to convert */
int filenum;					/* current file number */
int fhandle;					/* file pointer */
int nhandle;					/* new file pointer */
char *srcfile;					/* buffer holding loaded file */
unsigned char *tempdata;			/* buffer holding uncompressed ascii data */
long tdatasize;				/* size of buffer holding uncompressed data */

int byte_count;
int line_count;

OBJECT *daddr;					/* address of dialog box */
OBJECT *paddr;					/* address of percent dialog box */
int exitobj;					/* button that exits dialog box */

long src_counter;

int brush_w;					/* width of brush in pixels */
int brush_h;					/* height of brush in pixels */
int compression;				/* if brush data to convert is compressed */
long body_size;

int items_per_line;				/* count words per line in new file */

int data_type;					/* 8 bit CRY, 16 bit CRY, 8 bit RGB or 16 bit RGB data */
unsigned int color_offset;		/* offset for cry lookup table */
unsigned char intensity;
unsigned char red,green,blue;		/* RGB colors for each pixel */
extern unsigned char cry[];		/* cry lookup table */

int inc_all_palettes;			/* if palette should be saved in file */
int inc_1_palette;				/* only include palette for first image */
int verify;					/* if palette for each brush should be verified */
int verify_failed;				/* flag is set when brush palettes do not match */
int black_adjust;				/* change any colors of 0 in the palette so they are not transparent */
long completed;				/* % of lines converted lines from BBM file */

unsigned int firstpal[256];		/* palette colors for first brush */
unsigned int palette[256];		/* palette colors */
unsigned int palette_offset;
char *palette_ptr;

char filenotfound[] =	"[1][File not found.][  OK  ]";
char outofmemory[] =	"[1][Not enough memory.][  OK  ]";
char wrongformat[] =	"[1][Wrong file format.][  OK  ]";

main()
{
	appl_init();							/* initialize application */
	handle = graf_handle(&dummy, &dummy, &dummy, &dummy);
	for (i = 1; i < 10; ++i)
		work_in[i] = 1;
	work_in[0] = Getrez() + 2;
	work_in[10] = 2;
	v_opnvwk(work_in, &handle, work_out);
	rsrc_load("BBM.RSC");
	rsrc_gaddr(0,MENUS,&menuaddr);			/* get address of menu bar */
	inc_1_palette = NO;						/* include palette */
	inc_all_palettes = NO;
	menu_icheck(menuaddr,INC1PAL,NO);
	menu_icheck(menuaddr,INCALPAL,NO);
	menu_icheck(menuaddr,NOPAL,YES);			/* default option is no palette */

	verify = NO;
	menu_icheck(menuaddr,VERIFPAL,NO);			/* default option is no verify */
	black_adjust = YES;
	menu_icheck(menuaddr,BLACKADJ,YES);		/* default option is adjust black in palette */

	data_type = BIT8CRY;					/* default is 8 bit CRY data */
	menu_icheck(menuaddr,CRY8,YES);			/* 8 bit CRY data checked */
	menu_icheck(menuaddr,CRY16,NO);			/* 16 bit CRY data not checked */
	menu_icheck(menuaddr,RGB8,NO);			/* 8 bit RGB data not checked */
	menu_icheck(menuaddr,RGB16,NO);			/* 16 bit RGB data not checked */
	menu_bar(menuaddr,YES);					/* show the menu bar */
	rsrc_gaddr(R_TREE, PERCENT, &paddr);		/* get address of percent box */
	getpath();							/* get default path */
	ARROW_MOUSE;

	quit = NO;
	while(quit == NO)
	{
		event_type = evnt_multi((MU_MESAG|MU_KEYBD),
					1,1,1,				/* evnt_button       */
					0,0,0,0,0,			/* mouse enters rect */
					1,0,0,0,0,			/* mouse exits rect  */
					mgbuf,				/* evnt_mesg         */
					0,0,					/* evnt_timer        */
					&mousex,&mousey,		/* mouse x,y pos     */
					&dummy,				/* mouse button      */
					&dummy,				/* shift keys        */
					&key,				/* key pressed       */
					&dummy);				/* no. of clicks     */
		wind_update(BEG_UPDATE);
		if(event_type & MU_MESAG)
		{
			if(mgbuf[0] == MN_SELECTED)
				hndl_menu(mgbuf[3],mgbuf[4]);
		}
		else if(event_type & MU_KEYBD)
		{
			switch(key)
			{
				case F1_KEY:	hndl_menu(FILEMENU,CONVFILE);
								break;
				case F10_KEY:	hndl_menu(FILEMENU,TODESK);
								break;
			}	
		}
		wind_update(END_UPDATE);
	}
	menu_bar(menuaddr,NO);							/* turn off menu bar */
	v_clsvwk(handle);
	appl_exit();
}

/* getpath() gets the current path after the program is loaded */
getpath()
{
	char buffer[120];					/* used in the pathname construction */
	name[0] = '\0';
	Dgetpath(buffer,0);								/* get current pathname */
	sprintf(drv,"%c",drive = Dgetdrv() + 'A');
	strcpy(dirset,drv);								/* add drive letter */
	strcat(dirset,":");
	strcat(dirset,buffer);							/* add path to drive */
	strcat(dirset,"\\*.?BM");						/* add \*.?BM */
	strcpy(dirpath,dirset);							/* construct the pathname */
}

/*************************************************************************
fix_path() removes all characters after the last backslash in the
directory path.  This is used to remove the *.* or other string that the
file selector uses to get a directory
the file name chosen in the file selector is then added to the path to
make the complete path string
**************************************************************************/
fix_path()
{
	strcpy(pathname,dirpath);         /* leave dirpath unchanged */
	for (i=strlen(pathname); ((i > 0) && pathname[i] != '\\'); i--)
		;
	pathname[i+1] = '\0';
	strcat(pathname, filename[filenum]);
}
fix_savepath()
{
	strcpy(savepathname,savepath);         /* leave savepath unchanged */
	for (i=strlen(savepathname); ((i > 0) && savepathname[i] != '\\'); i--)
		;
	savepathname[i+1] = '\0';
	strcat(savepathname, name);
}

/***************************************************************************
add_extension() removes the extension from the filename of the IFF file
that was loaded.  Then .CRY is added to get the new default filename
that appears when you choose the file to save
***************************************************************************/
add_extension()
{
	strcpy(savepath,dirpath);
	for (i=strlen(savepath); ((i > 0) && savepath[i] != '\\'); i--)
		;
	savepath[i+1] = '\0';
	if((data_type == BIT16RGB) || (data_type == BIT8RGB))
		strcat(savepath, "*.RGB");
	else
		strcat(savepath, "*.CRY");
	strcpy(name,filename[0]);
	for (i=strlen(name); i >= 0; i--)
		if(i == 0 || name[i] == '.')
		{
			if(name[i] == '.')
				name[i+1] = '\0';
			else
				strcat(name, ".");
			if((data_type == BIT16RGB) || (data_type == BIT8RGB))
				strcat(name, "RGB");
			else
				strcat(name, "CRY");
			break;
		}
}

/***********************************************************************
get the file name of the brush, remove the extension if any, and
change the upper case letters to lower case letters
this name will be used as the label for the brush data
***********************************************************************/
get_name_without_ext()
{
	strcpy(picname,filename[filenum]);
	for (i=strlen(picname); i >= 0; i--)
		if(picname[i] == '.')
			picname[i] = '\0';
		else if(picname[i] >= 'A' && picname[i] <= 'Z')
			picname[i] += 32;				/* change 'A'-'Z' to 'a'-'z' */
}

/***********************************************************************
readfile() reads the file selected in the file selector into the
srcfile buffer.  It returns 1 after a successful load or 0 after an
unsuccessful load
************************************************************************/

filelist()
{
	int stop = NO;
	DMABUFFER tempbuf;
	Fsetdta(&tempbuf);
	strcpy(dirpath, dirset);
	filecount = 0;
	strcpy(name,"*.?BM");					/* default filename is *.?BM */
	if (fsel_exinput(dirpath, name, &button, "LOAD DPAINT FILE") == 0)
		return(0);
	else if ((button == 1) && (name[0] != '\0'))	/* selected a file */
	{
		strcpy(pathname,dirpath);
		for (i=strlen(pathname); ((i > 0) && pathname[i] != '\\'); i--)
			;
		pathname[i+1] = '\0';
		strcat(pathname, name);
		if(Fsfirst(pathname, 0) == 0)
		{
			filesize[filecount] = tempbuf.d_fsize;
			strcpy(filename[filecount++], tempbuf.d_fname);
			while(stop == NO)
			{
				if(Fsnext() == 0)			/* file was found */
				{
					filesize[filecount] = tempbuf.d_fsize;
					strcpy(filename[filecount++],tempbuf.d_fname);
				}
				else
					stop = YES;
			}
			add_extension();
			if(fsel_exinput(savepath, name, &button, "SAVE NEW DATA") == 0)
				return(0);
			else if ((button == 1) && (name[0] != '\0'))
			{
				fix_savepath();
				(int)nhandle = Fcreate(savepathname, 0x00);
			}
		}
		else
		{
			stop = YES;
			form_alert(1, filenotfound);		/* no files found */
			return(0);
		}
	}
}

/***********************************************************************
make_new_file() reads the BBM or LBM file, uncompresses it if
necessary, and writes the data into a new file
************************************************************************/
make_new_file()
{
	draw_current_filenum();
	fix_path();
	srcfile = (char *)Malloc(filesize[filenum]);
	if(srcfile != NULL)
	{
		BEE_MOUSE;
		fhandle = (int)Fopen(pathname,2);
		Fread(fhandle, filesize[filenum], srcfile);
		Fclose (fhandle);
	}
	else
	{
		form_alert(1, outofmemory);
		return(0);
	}
	if(uncompress_file() == 0)
		return(0);
	get_name_without_ext();
	get_palette();
	if(filenum == 0)
		for(i = 0; i < 256; i++)
			firstpal[i] = palette[i];
	make_finaldata();
	Mfree(srcfile);
	Mfree(tempdata);
}

make_finaldata()
{
	if(inc_all_palettes == YES)
		write_palette();
	else if((inc_1_palette == YES) && (filenum == 0))
		write_palette();

	sprintf(ts,"%s::\n",picname);
	Fwrite(nhandle, (long)strlen(ts), ts);
	sprintf(ts,";size is %d x %d\n",brush_w,brush_h);
	Fwrite(nhandle, (long)strlen(ts), ts);
	if((verify_failed == YES) && (filenum > 0))
	{
		sprintf(ts,";palette colors that don't match the first palette:\n;");
		Fwrite(nhandle, (long)strlen(ts), ts);
		for(i = 0; i < 256; i++)
			if(firstpal[i] != palette[i])
			{
				sprintf(ts,"%d,",i);
				Fwrite(nhandle, (long)strlen(ts), ts);
			}
		Fwrite(nhandle, 1L, "\n");
	}

	items_per_line = 0;
	switch(data_type)
	{
		case BIT8CRY:	write_8bit_data();
					break;
		case BIT16CRY:	write_16bit_data();
					break;
		case BIT8RGB:	write_8bit_data();
					break;
		case BIT16RGB:	write_16bit_data();
					break;
	}
	Fwrite(nhandle, 1L, "\n");		/* end of data */
}

write_8bit_data()
{
	unsigned long y;
	for(y = 0L; y < tdatasize; y++)
	{
		if(items_per_line == 0)
		{
			Fwrite(nhandle, 6L, "\tdc.b\t");	/* start new line */
			sprintf(ts,"$%02x",tempdata[y]);
		}
		else
			sprintf(ts,",$%02x",tempdata[y]);
		Fwrite(nhandle, (long)strlen(ts), ts);
		if(items_per_line++ == 15)				/* print 16 bytes per line */
		{
			Fwrite(nhandle, 1L, "\n");
			items_per_line = 0;
			completed = (y+1L) * 100L / tdatasize;
			sprintf(((TEDINFO *)paddr[PERCNTGE].ob_spec)->te_ptext,"%3ld", completed);
			objc_draw(paddr, PERCNTGE, ROOT, pxdial, pydial, pwdial, phdial);
		}
	}
}

write_16bit_data()
{
	unsigned long y;
	for(y = 0L; y < tdatasize; y++)
	{
		if(items_per_line == 0)
		{
			Fwrite(nhandle, 6L, "\tdc.w\t");	/* start new line */
			sprintf(ts,"$%04x",palette[tempdata[y]]);
		}
		else
			sprintf(ts,",$%04x",palette[tempdata[y]]);
		Fwrite(nhandle, (long)strlen(ts), ts);
		if(items_per_line++ == 15)				/* print 16 words per line */
		{
			Fwrite(nhandle, 1L, "\n");
			items_per_line = 0;
			completed = (y+1L) * 100L / tdatasize;
			sprintf(((TEDINFO *)paddr[PERCNTGE].ob_spec)->te_ptext,"%3ld", completed);
			objc_draw(paddr, PERCNTGE, ROOT, pxdial, pydial, pwdial, phdial);
		}
	}
}

uncompress_file()
{
	int a,c;
	int *temp;
	long *temp1;
	for(src_counter = 0L; src_counter < filesize[filenum]; src_counter++)
	{
		if((srcfile[src_counter] & 0xFF) == 'B')
			if(memcmp(&srcfile[src_counter],"BMHD",4) == 0)
			{
				temp = &srcfile[src_counter+8L];
				(int)brush_w = *temp;
				temp = &srcfile[src_counter+10L];
				(int)brush_h = *temp;
				(int)compression = (char)srcfile[src_counter+18L];
			}
		else if(memcmp(&srcfile[src_counter],"BODY",4) == 0)
		{
			temp1 = &srcfile[src_counter+4L];
			body_size = (*temp1)+1 & 0xFFFFFFFEL;		/* make it even number */
			src_counter += 8L;						/* skip size bytes */
			break;
		}
	}
	if(src_counter == filesize[filenum])
	{
		form_alert(1, wrongformat);
		return(0);
	}
	
	tempdata = (char *)Malloc(256000L);
	if(tempdata == 0)
	{
		form_alert(1, outofmemory);
		return(0);
	}
	byte_count = line_count = 0;
	tdatasize = 0L;
	if(compression == 1)
	{
		while(line_count < brush_h)
		{
			if(byte_count >= ((brush_w+1) & 0xFFFE))	/* round up to mult of 2 */
			{
				tempdata[tdatasize++] = 0;
				byte_count++;
			}
			else
			{
				if(srcfile[src_counter] < 0 && srcfile[src_counter] != -128)
					replicate_byte();
				else
					if(srcfile[src_counter] >= 0)
						copy_bytes();
			}
			if(byte_count >= brush_w)
			{
				byte_count = 0;
				line_count++;
			}
		}
	}
	else
	{
		for(a = 0; a < brush_h; a++)
			for(c = 0; c < brush_w; c++)
				tempdata[tdatasize++] = srcfile[src_counter++];
	}
	return(1);									/* success */
}

replicate_byte()
{
	int b;
	for(dummy = srcfile[src_counter]; dummy <= 0; dummy++)
	{
		b = srcfile[src_counter+1L] & 0xFF;
		tempdata[tdatasize++] = b;
		byte_count++;
	}	
	src_counter += 2L;				/* skip control byte and replicated byte */
}

copy_bytes()
{
	int c = srcfile[src_counter];	/* number of bytes to copy */
	for(dummy = 0; dummy <= c; dummy++)
	{
		src_counter++;
		tempdata[tdatasize++] = srcfile[src_counter] & 0xFF;
		byte_count++;
	}	
	src_counter++;					/* control byte and copied bytes */
}

do_about_box()
{
	rsrc_gaddr(R_TREE, ABOUTBOX, &daddr);
	form_center(daddr, &xdial, &ydial, &wdial, &hdial);
	form_dial(FMD_START, 0, 0, 0, 0, xdial, ydial, wdial, hdial);
	form_dial(FMD_GROW, 0, 0, 0, 0, xdial, ydial, wdial, hdial);
	objc_draw(daddr, ROOT, MAX_DEPTH, xdial, ydial, wdial, hdial);
	exitobj = form_do(daddr,0) & 0x7FFF;
	objc_change(daddr,exitobj,0,DESKSIZE,NORMAL,0);
	form_dial(FMD_SHRINK, 0, 0, 0, 0, xdial, ydial, wdial, hdial);
	form_dial(FMD_FINISH, 0, 0, 0, 0, xdial, ydial, wdial, hdial);
}

open_percent_box()
{
	form_center(paddr, &pxdial, &pydial, &pwdial, &phdial);
	form_dial(FMD_START, 0, 0, 0, 0, pxdial, pydial, pwdial, phdial);
	form_dial(FMD_GROW, 0, 0, 0, 0, pxdial, pydial, pwdial, phdial);
	objc_draw(paddr, ROOT, MAX_DEPTH, pxdial, pydial, pwdial, phdial);
}

draw_current_filenum()
{
	sprintf(((TEDINFO *)paddr[CURFILE].ob_spec)->te_ptext,"%2d", filenum+1);
	objc_draw(paddr, CURFILE, MAX_DEPTH, pxdial, pydial, pwdial, phdial);
}

hndl_menu(title,item)
int title;							/* title is menu from menu bar */
int item;								/* item is choice in the menu */
{
	switch (title)
	{
		case DESKMENU:	do_about_box();
					break;
		case FILEMENU:	switch(item)
					{
						case CONVFILE:	filelist();
									if(filecount > 0)
									{
										completed = 0L;
										sprintf(((TEDINFO *)paddr[PERCNTGE].ob_spec)->te_ptext,"%3ld", completed);
										sprintf(((TEDINFO *)paddr[CURFILE].ob_spec)->te_ptext," 1");
										sprintf(((TEDINFO *)paddr[TOTFILES].ob_spec)->te_ptext,"%2d", filecount);
										HIDE_MOUSE;
										open_percent_box();
										SHOW_MOUSE;
										for(filenum=0; filenum < filecount; filenum++)
											make_new_file();
										filecount = 0;
									}
									Fclose(nhandle);
									form_dial(FMD_SHRINK,0,0,0,0,pxdial,pydial,pwdial,phdial);	/* percent box */
									form_dial(FMD_FINISH,0,0,0,0,pxdial,pydial,pwdial,phdial);
									ARROW_MOUSE;
									SHOW_MOUSE;
									break;
						case TODESK:	quit = YES;
									break;
					}
					break;
		case OPTMENU:	switch(item)
					{
						case INC1PAL:	inc_1_palette = YES;
									inc_all_palettes = NO;
									menu_icheck(menuaddr,item,YES);
									menu_icheck(menuaddr,INCALPAL,NO);
									menu_icheck(menuaddr,NOPAL,NO);
									break;
						case INCALPAL:	inc_all_palettes = YES;
									menu_icheck(menuaddr,item,YES);
									menu_icheck(menuaddr,INC1PAL,NO);
									menu_icheck(menuaddr,NOPAL,NO);
									break;
						case NOPAL:	inc_1_palette = NO;
									inc_all_palettes = NO;
									menu_icheck(menuaddr,INC1PAL,NO);
									menu_icheck(menuaddr,INCALPAL,NO);
									menu_icheck(menuaddr,NOPAL,YES);
									break;
						case VERIFPAL:	verify = 1 - verify;
									menu_icheck(menuaddr,VERIFPAL,verify);
									break;
						case BLACKADJ:	black_adjust = 1 - black_adjust;
									menu_icheck(menuaddr,BLACKADJ,black_adjust);
									break;
						case CRY8:	data_type = BIT8CRY;
									menu_icheck(menuaddr,CRY8,YES);
									menu_icheck(menuaddr,CRY16,NO);
									menu_icheck(menuaddr,RGB8,NO);
									menu_icheck(menuaddr,RGB16,NO);
									break;
						case CRY16:	data_type = BIT16CRY;
									menu_icheck(menuaddr,CRY8,NO);
									menu_icheck(menuaddr,CRY16,YES);
									menu_icheck(menuaddr,RGB8,NO);
									menu_icheck(menuaddr,RGB16,NO);
									break;
						case RGB8:	data_type = BIT8RGB;
									menu_icheck(menuaddr,CRY8,NO);
									menu_icheck(menuaddr,CRY16,NO);
									menu_icheck(menuaddr,RGB8,YES);
									menu_icheck(menuaddr,RGB16,NO);
									break;
						case RGB16:	data_type = BIT16RGB;
									menu_icheck(menuaddr,CRY8,NO);
									menu_icheck(menuaddr,CRY16,NO);
									menu_icheck(menuaddr,RGB8,NO);
									menu_icheck(menuaddr,RGB16,YES);
									break;
					}
					break;
	}
	menu_tnormal(menuaddr,title,YES);			/* return menu item to normal */
}

get_palette()
{
/**********************************************************************
	a brush file has 3 bytes for each of the 256 colors (R,G,B)
	each 3 bytes will be converted to a 16 bit color
***********************************************************************/
 	for(src_counter = 0L; src_counter < filesize[filenum]; src_counter++)
		if((srcfile[src_counter] & 0xFF) == 'C')
			if(memcmp(&srcfile[src_counter],"CMAP",4) == 0)
			{
				palette_ptr = &srcfile[src_counter+8L];
				break;
			}

	palette_offset = 0;					/* counter for palette array */
	items_per_line = 0;
	switch(data_type)
	{
		case BIT8CRY:	get_cry_palette();
					break;
		case BIT16CRY:	get_cry_palette();
					break;
		case BIT8RGB:	get_rgb_palette();
					break;
		case BIT16RGB:	get_rgb_palette();
					break;
	}
}

get_cry_palette()
{
	int temp0,temp1;
	verify_failed = NO;
	for(i = 0; i < (256 * 3); i += 3)
	{
		red = palette_ptr[i];
		green = palette_ptr[i+1];
		blue = palette_ptr[i+2];

		intensity = red;				/* start with red */
		if(green > intensity)
			intensity = green;
		if(blue > intensity)
			intensity = blue;			/* get highest RGB value */
		if(intensity != 0)
		{
			red = (unsigned int)red * 255 / intensity;
			green = (unsigned int)green * 255 / intensity;
			blue = (unsigned int)blue * 255 / intensity;
		}
		else
			red = green = blue = 0;		/* R, G, B, were all 0 (black) */

		color_offset = (red & 0xF8) << 7;
		color_offset += (green & 0xF8) << 2;
		color_offset += (blue & 0xF8) >> 3;		/* now we have offset for cry table */

		temp0 = cry[color_offset] * 256 + intensity;		/* get the CRY color */
		if((i > 0) && (temp0 == 0) && (black_adjust == YES))
			temp0 = 0x7800;			/* make sure no colors other than 0 will be transparent (set to white with 0 intensity) */
		if((verify == YES) && (filenum > 0))
		{
			temp1 = palette[palette_offset];
			palette[palette_offset++] = temp0;
			if(temp0 != temp1)
				verify_failed = YES;
		}
		else
			palette[palette_offset++] = temp0;
	}
}

get_rgb_palette()
{
	int temp1,temp2;
	for(i = 0; i < (256 * 3); i += 3)
	{
		red = palette_ptr[i];
		green = palette_ptr[i+1];
		blue = palette_ptr[i+2];

		temp2 = (red >> 3) << 5;				/* reduce red to 5 bits, shift left 5 bits */
		temp2 += blue >> 3;					/* reduce blue to 5 bits */
		temp2 = temp2 << 6;					/* shift red and blue left 6 bits to make room for green */
		temp2 += green >> 2;				/* reduce green to 6 bits */

		if((i > 0) && (temp2 == 0) && (black_adjust == YES))
			temp2 = 0x0001;			/* make sure no colors other than 0 will be transparent (set green to 1) */
		if((verify == YES) && (filenum > 0))
		{
			temp1 = palette[palette_offset];
			palette[palette_offset++] = temp2;
			if(temp2 != temp1)
				verify_failed = YES;
		}
		else
			palette[palette_offset++] = temp2;

	}
}

write_palette()
{
	sprintf(ts,"%s_palette:\n",picname);			/* palette label */
	Fwrite(nhandle, (long)strlen(ts), ts);

	for(i = 0; i < 256; i++)
	{
		if(items_per_line == 0)
			Fwrite(nhandle, 6L, "\tdc.w\t");	/* start new line */
		if(items_per_line == 0)
			sprintf(ts,"$%04x",palette[i]);
		else
			sprintf(ts,",$%04x",palette[i]);
		Fwrite(nhandle, (long)strlen(ts), ts);
		if(items_per_line++ == 15)
		{
			Fwrite(nhandle, 1L, "\n");		/* end of line */
			items_per_line = 0;
		}
	}
	Fwrite(nhandle, 1L, "\n");
}

